<?php

namespace App\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Adresses extends Model 
{

    protected $table = 'addresses';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('costumer_id', 'address', 'city_id');
    protected $visible = array('costumer_id', 'address', 'city_id');

    public function costumer()
    {
        return $this->belongsTo('App\Entities\Costumer');
    }

    public function city()
    {
        return $this->belongsTo('App\Entities\City');
    }

}